/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XlsxRunHelper
extends BaseHelper {
    private Map<String, String> fontMap;
    private String exporterKey;

    public XlsxRunHelper(Writer writer, Map<String, String> fontMap, String exporterKey) {
        super(writer);
        this.fontMap = fontMap;
        this.exporterKey = exporterKey;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        if (text != null) {
            this.write("<r>\n");
            this.exportProps(this.getAttributes(style), attributes, locale);
            this.write("<t xml:space=\"preserve\">");
            this.write(JRStringUtil.xmlEncode(text));
            this.write("</t></r>\n");
        }
    }

    public void exportProps(JRStyle style, Locale locale) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (style.getModeValue() == null || style.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, style.getBackcolor());
        }
        this.exportProps(this.getAttributes(style.getStyle()), this.getAttributes(style), locale);
    }

    public void exportProps(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale) {
        this.write("       <rPr>\n");
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            String fontFamilyAttr;
            String fontFamily = fontFamilyAttr = (String)value;
            if (this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr)) {
                fontFamily = this.fontMap.get(fontFamilyAttr);
            } else {
                FontFamily family;
                String exportFont;
                FontInfo fontInfo = JRFontUtil.getFontInfo(fontFamilyAttr, locale);
                if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
                    fontFamily = exportFont;
                }
            }
            this.write("        <rFont val=\"" + fontFamily + "\"/>\n");
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <color rgb=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <sz val=\"" + value + "\" />\n");
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <b val=\"" + value.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <i val=\"" + value.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <u val=\"" + (value == null ? "none" : "single") + "\"/>\n");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <strike val=\"" + (value != null) + "\"/>\n");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.write("        <vertAlign val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.write("        <vertAlign val=\"subscript\" />\n");
        }
        this.write("       </rPr>\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

