/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class BasicDynaBean
implements DynaBean {
    protected DynaClass dynaClass = null;
    protected HashMap values = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public BasicDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public boolean contains(String name, String key) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    public Object get(String name) {
        Object value = this.values.get(name);
        if (value != null) {
            return value;
        }
        Class type = this.getDynaProperty(name).getType();
        if (!type.isPrimitive()) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        return null;
    }

    public Object get(String name, int index) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (value.getClass().isArray()) {
            return Array.get(value, index);
        }
        if (value instanceof List) {
            return ((List)value).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
    }

    public Object get(String name, String key) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String name, String key) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object value = this.values.get(name);
        if (value == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
        }
        ((Map)value).remove(key);
    }

    public void set(String name, Object value) {
        DynaProperty descriptor = this.getDynaProperty(name);
        if (value == null) {
            if (descriptor.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(descriptor.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + descriptor.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    public void set(String name, int index, Object value) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object prop = this.values.get(name);
        if (prop == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (prop.getClass().isArray()) {
            Array.set(prop, index, value);
        } else if (prop instanceof List) {
            try {
                ((List)prop).set(index, value);
            }
            catch (ClassCastException e) {
                throw new ConversionException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
        }
    }

    public void set(String name, String key, Object value) {
        DynaProperty descriptor = this.getDynaProperty(name);
        Object prop = this.values.get(name);
        if (prop == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (!(prop instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
        }
        ((Map)prop).put(key, value);
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty descriptor = this.getDynaClass().getDynaProperty(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid property name '" + name + "'");
        }
        return descriptor;
    }

    protected boolean isAssignable(Class dest, Class source) {
        return dest.isAssignableFrom(source) || dest == Boolean.TYPE && source == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) || dest == Byte.TYPE && source == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte) || dest == Character.TYPE && source == (class$java$lang$Character == null ? (class$java$lang$Character = BasicDynaBean.class$("java.lang.Character")) : class$java$lang$Character) || dest == Double.TYPE && source == (class$java$lang$Double == null ? (class$java$lang$Double = BasicDynaBean.class$("java.lang.Double")) : class$java$lang$Double) || dest == Float.TYPE && source == (class$java$lang$Float == null ? (class$java$lang$Float = BasicDynaBean.class$("java.lang.Float")) : class$java$lang$Float) || dest == Integer.TYPE && source == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer) || dest == Long.TYPE && source == (class$java$lang$Long == null ? (class$java$lang$Long = BasicDynaBean.class$("java.lang.Long")) : class$java$lang$Long) || dest == Short.TYPE && source == (class$java$lang$Short == null ? (class$java$lang$Short = BasicDynaBean.class$("java.lang.Short")) : class$java$lang$Short);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

