/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;

final class PLPXMLInputStream
extends PLPInputStream {
    private static final byte[] xmlBOM = new byte[]{-1, -2};
    private final ByteArrayInputStream bomStream = new ByteArrayInputStream(xmlBOM);

    static final PLPXMLInputStream makeXMLStream(TDSReader tDSReader, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        long l = tDSReader.readLong();
        if (-1L == l) {
            return null;
        }
        PLPXMLInputStream pLPXMLInputStream = new PLPXMLInputStream(tDSReader, l, inputStreamGetterArgs, serverDTVImpl);
        if (null != pLPXMLInputStream) {
            pLPXMLInputStream.setLoggingInfo(inputStreamGetterArgs.logContext);
        }
        return pLPXMLInputStream;
    }

    PLPXMLInputStream(TDSReader tDSReader, long l, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, l, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
    }

    public void close() throws IOException {
        super.close();
    }

    int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        assert (n >= 0);
        assert (n2 >= 0);
        if (0 == n2) {
            return 0;
        }
        int n5 = 0;
        if (null == byArray) {
            n4 = 0;
            for (n3 = 0; n3 < n2 && 0 != (n4 = (int)this.bomStream.skip(n2 - n3)); n3 += n4) {
            }
        } else {
            n4 = 0;
            while (n3 < n2 && -1 != (n4 = this.bomStream.read(byArray, n + n3, n2 - n3))) {
                n3 += n4;
            }
        }
        while (n3 < n2 && -1 != (n5 = super.readBytes(byArray, n + n3, n2 - n3))) {
            n3 += n5;
        }
        if (n3 > 0) {
            return n3;
        }
        assert (-1 == n5);
        return -1;
    }

    public void mark(int n) {
        this.bomStream.mark(xmlBOM.length);
        super.mark(n);
    }

    public void reset() throws IOException {
        this.bomStream.reset();
        super.reset();
    }

    byte[] getBytes() throws SQLServerException {
        byte[] byArray = new byte[2];
        try {
            int n = this.bomStream.read(byArray);
            byte[] byArray2 = super.getBytes();
            if (n > 0) {
                assert (2 == n);
                byte[] byArray3 = new byte[byArray2.length + n];
                System.arraycopy(byArray, 0, byArray3, 0, n);
                System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
                return byArray3;
            }
            return byArray2;
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            return null;
        }
    }
}

