/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

class IntColumnIdentityFilter
extends ColumnFilter {
    IntColumnIdentityFilter() {
    }

    private static final String zeroOneToYesNo(Integer n) {
        return 0 == n ? "NO" : "YES";
    }

    final Object apply(Object object, JDBCType jDBCType) throws SQLServerException {
        if (object == null) {
            return object;
        }
        switch (jDBCType) {
            case INTEGER: {
                return IntColumnIdentityFilter.zeroOneToYesNo((Integer)object);
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return IntColumnIdentityFilter.zeroOneToYesNo(Integer.parseInt((String)object));
            }
        }
        DataTypes.throwConversionError("char", jDBCType.toString());
        return object;
    }
}

