/*
 * Decompiled with CFR 0.152.
 */
package jlfSistemas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class CuadroImagen
extends JPanel
implements Printable {
    private float zoom = 0.0f;
    private int ancho;
    private int alto;
    private BufferedImage bufferImagen;
    private Image imagen;
    private Image imagenAux;
    private boolean hayFoto = false;

    public CuadroImagen() {
        this.setBounds(0, 0, 500, 500);
        this.setVisible(true);
    }

    public void setImagen(String dirImg) {
        this.zoom = 0.0f;
        try {
            this.bufferImagen = ImageIO.read(new File(dirImg));
            this.imagenAux = this.imagen = this.bufferImagen;
            this.hayFoto = true;
            this.ancho = this.imagen.getWidth(this);
            this.alto = this.imagen.getHeight(this);
            this.resize();
            this.repaint();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImagen2(ImageIcon imageIcon) {
        this.zoom = 0.0f;
        this.imagenAux = this.imagen = CuadroImagen.iconToImage(imageIcon);
        this.hayFoto = true;
        this.ancho = this.imagen.getWidth(this);
        this.alto = this.imagen.getHeight(this);
        this.resize();
        this.repaint();
    }

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.hayFoto) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
            g2d.translate(-this.ancho / 2, -this.alto / 2);
            g2d.drawImage(this.imagenAux, 0, 0, this.ancho, this.alto, this);
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
        super.paintComponent(g2d);
    }

    public void aumentar() {
        this.zoom = (float)((double)this.zoom + 0.1);
        this.ancho = (int)((float)this.imagen.getWidth(this) * (this.zoom + 1.0f));
        this.alto = (int)((float)this.imagen.getHeight(this) * (this.zoom + 1.0f));
        this.imagenAux = this.imagen.getScaledInstance(this.ancho, this.alto, 16);
        this.resize();
        this.repaint();
    }

    public void disminuir() {
        this.zoom = (float)((double)this.zoom - 0.1);
        this.ancho = (int)((float)this.imagen.getWidth(this) * (this.zoom + 1.0f));
        this.alto = (int)((float)this.imagen.getHeight(this) * (this.zoom + 1.0f));
        this.imagenAux = this.imagen.getScaledInstance(this.ancho, this.alto, 16);
        this.resize();
        this.repaint();
    }

    public void resize() {
        this.setPreferredSize(new Dimension(this.ancho, this.alto));
        this.resize(this.ancho, this.alto);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int indexPage) throws PrinterException {
        if (indexPage == 0) {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.imagen, 0, 0, (int)pf.getWidth(), (int)pf.getHeight(), this);
            return 0;
        }
        return 1;
    }

    public void imprimir() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        PageFormat pageFormat = new PageFormat();
        pageFormat = job.pageDialog(pageFormat);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }
}

