/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import net.ucanaccess.jdbc.UcanaccessDataSourceFactory;
import net.ucanaccess.jdbc.UcanaccessDriver;

public class UcanaccessDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = 8574198937631043152L;
    private String accessPath;
    private int loginTimeout = 0;
    private transient PrintWriter logWriter = net.ucanaccess.util.Logger.getLogPrintWriter();
    private String password = "";
    private String user;

    public String getAccessPath() {
        return this.accessPath;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.put("user", username);
        }
        if (password != null) {
            props.put("password", password);
        }
        return new UcanaccessDriver().connect("jdbc:ucanaccess://" + this.accessPath, props);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reference getReference() throws NamingException {
        String clazz = UcanaccessDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), clazz, null);
        ref.add(new StringRefAddr("accessPath", this.getAccessPath()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        return ref;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAccessPath(String accessPath) {
        this.accessPath = accessPath;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        net.ucanaccess.util.Logger.setLogPrintWriter(logWriter);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

