/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.complex;

import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.UnsupportedValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public abstract class ComplexBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String tableName;
    private String columnName;
    public static final ComplexValue.Id CREATE_ID = ComplexColumnInfoImpl.INVALID_ID;

    public ComplexBase(ComplexValue.Id id, String tableName, String columnName) {
        this.id = id.get();
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ComplexBase(ComplexValue cv) {
        this(cv.getId(), cv.getComplexValueForeignKey().getColumn().getTable().getName(), cv.getComplexValueForeignKey().getColumn().getName());
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexBase other = (ComplexBase)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public static final Object[] convert(ComplexValueForeignKey fk) throws IOException, UcanaccessSQLException {
        if (fk.getComplexType().equals((Object)ComplexDataType.ATTACHMENT)) {
            List lst = fk.getAttachments();
            Object[] lat = new Attachment[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new Attachment((com.healthmarketscience.jackcess.complex.Attachment)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.MULTI_VALUE)) {
            List lst = fk.getMultiValues();
            Object[] lat = new SingleValue[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new SingleValue((com.healthmarketscience.jackcess.complex.SingleValue)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.VERSION_HISTORY)) {
            List lst = fk.getVersions();
            Object[] lat = new Version[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new Version((com.healthmarketscience.jackcess.complex.Version)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.UNSUPPORTED)) {
            List lst = fk.getUnsupportedValues();
            Object[] lat = new UnsupportedValue[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new UnsupportedValue((com.healthmarketscience.jackcess.complex.UnsupportedValue)lst.get(i));
                ++i;
            }
            return lat;
        }
        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.COMPLEX_TYPE_UNSUPPORTED);
    }
}

