/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.DeleteResultSet;
import net.ucanaccess.jdbc.InsertResultSet;
import net.ucanaccess.jdbc.UcanaccessBlob;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.jdbc.UpdateResultSet;
import org.hsqldb.jdbc.JDBCResultSet;

public class UcanaccessResultSet
implements ResultSet {
    private ResultSet wrapped;
    private UcanaccessStatement wrappedStatement;
    private HashSet<String> metadata;

    public UcanaccessResultSet(ResultSet wrapped, UcanaccessStatement statement) {
        this.wrapped = wrapped;
        this.wrappedStatement = statement;
    }

    private String checkEscaped(String label) throws SQLException {
        if (label == null) {
            return null;
        }
        if (this.metadata == null) {
            this.loadMetadata();
        }
        if (this.metadata.contains(label.toUpperCase())) {
            return label;
        }
        String escaped = SQLConverter.basicEscapingIdentifier(label);
        escaped = escaped.replaceAll("[\"']", "");
        String slabel = label.substring(1).toUpperCase();
        if (SQLConverter.isXescaped(slabel) && this.metadata.contains(slabel)) {
            return slabel;
        }
        if (this.metadata.contains(escaped.toUpperCase())) {
            return escaped;
        }
        return label;
    }

    private void loadMetadata() throws SQLException {
        this.metadata = new HashSet();
        ResultSetMetaData rsmd = this.wrapped.getMetaData();
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            this.metadata.add(rsmd.getColumnLabel(i).toUpperCase());
            ++i;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            return this.wrapped.absolute(row);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.wrapped.afterLast();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.wrapped.beforeFirst();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.wrapped.cancelRowUpdates();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.wrapped.clearWarnings();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.wrapped.close();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            new DeleteResultSet(this).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            return this.wrapped.findColumn(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this.wrapped.first();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Array getArray(int idx) throws SQLException {
        try {
            return this.wrapped.getArray(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getArray(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public InputStream getAsciiStream(int idx) throws SQLException {
        try {
            return this.wrapped.getAsciiStream(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getAsciiStream(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int idx) throws SQLException {
        try {
            return this.wrapped.getBigDecimal(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int idx, int arg1) throws SQLException {
        try {
            return this.wrapped.getBigDecimal(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getBigDecimal(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int arg1) throws SQLException {
        try {
            return this.wrapped.getBigDecimal(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(int idx) throws SQLException {
        try {
            return this.wrapped.getBinaryStream(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getBinaryStream(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Blob getBlob(int idx) throws SQLException {
        try {
            return new UcanaccessBlob(this.wrapped.getBlob(idx));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            return new UcanaccessBlob(this.wrapped.getBlob(this.checkEscaped(columnLabel)));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean getBoolean(int idx) throws SQLException {
        try {
            return this.wrapped.getBoolean(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getBoolean(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public byte getByte(int idx) throws SQLException {
        try {
            return this.wrapped.getByte(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getByte(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public byte[] getBytes(int idx) throws SQLException {
        try {
            return this.wrapped.getBytes(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getBytes(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream(int idx) throws SQLException {
        try {
            return this.wrapped.getCharacterStream(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getCharacterStream(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Clob getClob(int idx) throws SQLException {
        try {
            return this.wrapped.getClob(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getClob(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.wrapped.getConcurrency();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this.wrapped.getCursorName();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Date getDate(int idx) throws SQLException {
        try {
            return this.wrapped.getDate(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Date getDate(int idx, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getDate(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getDate(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getDate(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public double getDouble(int idx) throws SQLException {
        try {
            return this.wrapped.getDouble(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getDouble(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.wrapped.getFetchDirection();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.wrapped.getFetchSize();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public float getFloat(int idx) throws SQLException {
        try {
            return this.wrapped.getFloat(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getFloat(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.wrapped.getHoldability();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getInt(int idx) throws SQLException {
        try {
            return this.wrapped.getInt(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getInt(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public long getLong(int idx) throws SQLException {
        try {
            return this.wrapped.getLong(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getLong(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.wrapped.getMetaData();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Reader getNCharacterStream(int idx) throws SQLException {
        try {
            return this.wrapped.getNCharacterStream(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getNCharacterStream(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public NClob getNClob(int idx) throws SQLException {
        try {
            return this.wrapped.getNClob(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getNClob(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getNString(int idx) throws SQLException {
        try {
            return this.wrapped.getNString(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getNString(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Object getObject(int idx) throws SQLException {
        try {
            Object obj = this.wrapped.getObject(idx);
            if (obj instanceof Blob) {
                return new UcanaccessBlob((Blob)obj);
            }
            return obj;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            return (T)((JDBCResultSet)this.wrapped).getObject(columnIndex, type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Object getObject(int idx, Map<String, Class<?>> arg1) throws SQLException {
        try {
            Object obj = this.wrapped.getObject(idx, arg1);
            if (obj instanceof Blob) {
                return new UcanaccessBlob((Blob)obj);
            }
            return obj;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            Object obj = this.wrapped.getObject(this.checkEscaped(columnLabel));
            if (obj instanceof Blob) {
                return new UcanaccessBlob((Blob)obj);
            }
            return obj;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        try {
            return (T)((JDBCResultSet)this.wrapped).getObject(this.checkEscaped(columnLabel), type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> arg1) throws SQLException {
        try {
            return this.wrapped.getObject(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Ref getRef(int idx) throws SQLException {
        try {
            return this.wrapped.getRef(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getRef(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this.wrapped.getRow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public RowId getRowId(int idx) throws SQLException {
        try {
            return this.wrapped.getRowId(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getRowId(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public short getShort(int idx) throws SQLException {
        try {
            return this.wrapped.getShort(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getShort(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public SQLXML getSQLXML(int idx) throws SQLException {
        try {
            return this.wrapped.getSQLXML(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getSQLXML(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            return this.wrapped.getStatement();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getString(int idx) throws SQLException {
        try {
            return this.wrapped.getString(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getString(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Time getTime(int idx) throws SQLException {
        try {
            return this.wrapped.getTime(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Time getTime(int idx, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getTime(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getTime(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getTime(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int idx) throws SQLException {
        try {
            return this.wrapped.getTimestamp(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int idx, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getTimestamp(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getTimestamp(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar arg1) throws SQLException {
        try {
            return this.wrapped.getTimestamp(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this.wrapped.getType();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int idx) throws SQLException {
        try {
            return this.wrapped.getUnicodeStream(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        try {
            return this.wrapped.getUnicodeStream(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public URL getURL(int idx) throws SQLException {
        try {
            Object obj = this.wrapped.getObject(idx);
            return this.getURL(obj);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private URL getURL(Object obj) throws SQLException {
        try {
            String s;
            if (obj instanceof String && (s = (String)obj).startsWith("#") && s.endsWith("#")) {
                return new URL(s.substring(1, s.length() - 1));
            }
            throw new SQLException("Invalid or unsupported url format");
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public URL getURL(String cn) throws SQLException {
        try {
            Object obj = this.wrapped.getObject(this.checkEscaped(cn));
            return this.getURL(obj);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.wrapped.getWarnings();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public ResultSet getWrapped() {
        return this.wrapped;
    }

    public UcanaccessStatement getWrappedStatement() {
        return this.wrappedStatement;
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            new InsertResultSet(this).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this.wrapped.isAfterLast();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.wrapped.isBeforeFirst();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.wrapped.isClosed();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this.wrapped.isFirst();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this.wrapped.isLast();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.wrapped.isWrapperFor(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this.wrapped.last();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.wrapped.moveToCurrentRow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.wrapped.moveToInsertRow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.wrapped.next();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            return this.wrapped.previous();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.wrapped.refreshRow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean relative(int idx) throws SQLException {
        try {
            return this.wrapped.relative(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this.wrapped.rowDeleted();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this.wrapped.rowInserted();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this.wrapped.rowUpdated();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setFetchDirection(int idx) throws SQLException {
        try {
            this.wrapped.setFetchDirection(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setFetchSize(int idx) throws SQLException {
        try {
            this.wrapped.setFetchSize(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.wrapped.unwrap(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateArray(int idx, Array arg1) throws SQLException {
        try {
            this.wrapped.updateArray(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array arg1) throws SQLException {
        try {
            this.wrapped.updateArray(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(int idx, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(int idx, InputStream arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(int idx, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateAsciiStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBigDecimal(int idx, BigDecimal arg1) throws SQLException {
        try {
            this.wrapped.updateBigDecimal(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal arg1) throws SQLException {
        try {
            this.wrapped.updateBigDecimal(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(int idx, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(int idx, InputStream arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(int idx, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateBinaryStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(int idx, Blob arg1) throws SQLException {
        try {
            this.wrapped.updateBlob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(int idx, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateBlob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(int idx, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateBlob(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob arg1) throws SQLException {
        try {
            this.wrapped.updateBlob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream arg1) throws SQLException {
        try {
            this.wrapped.updateBlob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateBlob(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBoolean(int idx, boolean arg1) throws SQLException {
        try {
            this.wrapped.updateBoolean(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean arg1) throws SQLException {
        try {
            this.wrapped.updateBoolean(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateByte(int idx, byte arg1) throws SQLException {
        try {
            this.wrapped.updateByte(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte arg1) throws SQLException {
        try {
            this.wrapped.updateByte(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBytes(int idx, byte[] arg1) throws SQLException {
        try {
            this.wrapped.updateBytes(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] arg1) throws SQLException {
        try {
            this.wrapped.updateBytes(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(int idx, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(int idx, Reader arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(int idx, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateCharacterStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(int idx, Clob arg1) throws SQLException {
        try {
            this.wrapped.updateClob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(int idx, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateClob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(int idx, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateClob(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob arg1) throws SQLException {
        try {
            this.wrapped.updateClob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateClob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateClob(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateDate(int idx, Date arg1) throws SQLException {
        try {
            this.wrapped.updateDate(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date arg1) throws SQLException {
        try {
            this.wrapped.updateDate(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateDouble(int idx, double arg1) throws SQLException {
        try {
            this.wrapped.updateDouble(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double arg1) throws SQLException {
        try {
            this.wrapped.updateDouble(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateFloat(int idx, float arg1) throws SQLException {
        try {
            this.wrapped.updateFloat(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float arg1) throws SQLException {
        try {
            this.wrapped.updateFloat(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateInt(int idx, int arg1) throws SQLException {
        try {
            this.wrapped.updateInt(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateInt(String columnLabel, int arg1) throws SQLException {
        try {
            this.wrapped.updateInt(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateLong(int idx, long arg1) throws SQLException {
        try {
            this.wrapped.updateLong(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateLong(String columnLabel, long arg1) throws SQLException {
        try {
            this.wrapped.updateLong(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(int idx, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateNCharacterStream(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(int idx, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateNCharacterStream(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateNCharacterStream(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateNCharacterStream(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(int idx, NClob arg1) throws SQLException {
        try {
            this.wrapped.updateNClob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(int idx, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateNClob(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(int idx, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateNClob(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob arg1) throws SQLException {
        try {
            this.wrapped.updateNClob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader arg1) throws SQLException {
        try {
            this.wrapped.updateNClob(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader arg1, long arg2) throws SQLException {
        try {
            this.wrapped.updateNClob(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNString(int idx, String arg1) throws SQLException {
        try {
            this.wrapped.updateNString(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNString(String columnLabel, String arg1) throws SQLException {
        try {
            this.wrapped.updateNString(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNull(int idx) throws SQLException {
        try {
            this.wrapped.updateNull(idx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this.wrapped.updateNull(this.checkEscaped(columnLabel));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateObject(int idx, Object arg1) throws SQLException {
        try {
            this.wrapped.updateObject(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateObject(int idx, Object arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateObject(idx, arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object arg1) throws SQLException {
        try {
            this.wrapped.updateObject(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object arg1, int arg2) throws SQLException {
        try {
            this.wrapped.updateObject(this.checkEscaped(columnLabel), arg1, arg2);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateRef(int idx, Ref arg1) throws SQLException {
        try {
            this.wrapped.updateRef(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref arg1) throws SQLException {
        try {
            this.wrapped.updateRef(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            new UpdateResultSet(this).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateRowId(int idx, RowId arg1) throws SQLException {
        try {
            this.wrapped.updateRowId(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId arg1) throws SQLException {
        try {
            this.wrapped.updateRowId(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateShort(int idx, short arg1) throws SQLException {
        try {
            this.wrapped.updateShort(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateShort(String columnLabel, short arg1) throws SQLException {
        try {
            this.wrapped.updateShort(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateSQLXML(int idx, SQLXML arg1) throws SQLException {
        try {
            this.wrapped.updateSQLXML(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML arg1) throws SQLException {
        try {
            this.wrapped.updateSQLXML(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateString(int idx, String arg1) throws SQLException {
        try {
            this.wrapped.updateString(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateString(String columnLabel, String arg1) throws SQLException {
        try {
            this.wrapped.updateString(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateTime(int idx, Time arg1) throws SQLException {
        try {
            this.wrapped.updateTime(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time arg1) throws SQLException {
        try {
            this.wrapped.updateTime(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateTimestamp(int idx, Timestamp arg1) throws SQLException {
        try {
            this.wrapped.updateTimestamp(idx, arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp arg1) throws SQLException {
        try {
            this.wrapped.updateTimestamp(this.checkEscaped(columnLabel), arg1);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this.wrapped.wasNull();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }
}

