/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Cursor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.ICursorCommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class CompositeCommand
implements ICommand {
    private ArrayList<ICursorCommand> composite = new ArrayList();
    private Map<String, Object> currentRow;
    private String execId;
    private IndexSelector indexSelector;
    private ArrayList<ICursorCommand> rollbackCache = new ArrayList();

    public boolean add(ICursorCommand c4io) {
        if (this.indexSelector == null) {
            this.indexSelector = c4io.getIndexSelector();
            this.execId = c4io.getExecId();
        }
        return this.composite.add(c4io);
    }

    public ArrayList<ICursorCommand> getComposite() {
        return this.composite;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.composite.get(0).getTableName();
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.COMPOSITE;
    }

    public boolean moveToNextRow(Cursor cur, Collection<String> columnNames) throws IOException {
        boolean hasNext = cur.moveToNextRow();
        if (hasNext) {
            this.currentRow = cur.getCurrentRow(columnNames);
        }
        return hasNext;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Cursor cur = this.indexSelector.getCursor();
            cur.beforeFirst();
            Set<String> columnNames = this.composite.get(0).getRowPattern().keySet();
            block2: while (this.composite.size() > 0 && this.moveToNextRow(cur, columnNames)) {
                Iterator<ICursorCommand> it = this.composite.iterator();
                while (it.hasNext()) {
                    ICursorCommand comm = it.next();
                    if (!comm.currentRowMatches(cur, this.currentRow)) continue;
                    comm.persistCurrentRow(cur);
                    it.remove();
                    this.rollbackCache.add(comm);
                    continue block2;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        for (ICursorCommand ic : this.rollbackCache) {
            ic.rollback();
        }
        return null;
    }
}

