/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.ObjectRegistry;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.core.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.NoSerializationTestMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

abstract class InProcessMessagingInterface
extends MessagingInterface {
    private static final boolean IS_PRINTING_NON_SERIALIZABLE_MESSAGES = Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_INPROCESS_PRINTNONSERIALIZABLEMESSAGES.get());
    private volatile InProcessMessagingInterface mirrorMessagingInterface;
    private List<Message> sentMessageList = new LinkedList<Message>();

    public InProcessMessagingInterface(boolean isNativeSide, int pid) {
        super(isNativeSide, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ObjectRegistry controlRegistry = SWTNativeComponent.getControlRegistry();
        int[] nArray = controlRegistry.getInstanceIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int instanceID = nArray[n2];
            final Control control = (Control)controlRegistry.get(instanceID);
            controlRegistry.remove(instanceID);
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    control.getShell().dispose();
                }
            });
            ++n2;
        }
        InProcessMessagingInterface mirrorMessagingInterface = this.getMirrorMessagingInterface();
        this.setAlive(false);
        mirrorMessagingInterface.setAlive(false);
        List<Message> list = this.sentMessageList;
        synchronized (list) {
            this.sentMessageList.notifyAll();
        }
        list = mirrorMessagingInterface.sentMessageList;
        synchronized (list) {
            mirrorMessagingInterface.sentMessageList.notifyAll();
        }
    }

    protected void openChannel() {
    }

    protected void closeChannel() {
    }

    protected void setMirrorMessagingInterface(InProcessMessagingInterface mirrorMessagingInterface) {
        this.mirrorMessagingInterface = mirrorMessagingInterface;
    }

    public InProcessMessagingInterface getMirrorMessagingInterface() {
        return this.mirrorMessagingInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message getNextMessage() {
        boolean isAlive = this.isAlive();
        List<Message> list = this.sentMessageList;
        synchronized (list) {
            while (this.sentMessageList.isEmpty()) {
                try {
                    this.sentMessageList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                isAlive = this.isAlive();
                if (!isAlive) break;
            }
            if (!isAlive) {
                this.sentMessageList.clear();
                throw new IllegalStateException("The interface is closed.");
            }
            return this.sentMessageList.remove(0);
        }
    }

    protected Message readMessageFromChannel() throws IOException, ClassNotFoundException {
        return this.mirrorMessagingInterface.getNextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageToChannel(Message message) throws IOException {
        if (IS_PRINTING_NON_SERIALIZABLE_MESSAGES && !(message instanceof NoSerializationTestMessage)) {
            ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());
            try {
                oos.writeObject(message);
            }
            catch (Exception e) {
                System.err.println("Non-serializable message: " + message);
            }
            oos.close();
        }
        List<Message> list = this.sentMessageList;
        synchronized (list) {
            this.sentMessageList.add(message);
            this.sentMessageList.notifyAll();
        }
    }

    static class SWTInProcessMessagingInterface
    extends InProcessMessagingInterface {
        private Display display;

        public SWTInProcessMessagingInterface(Display display, int pid) {
            super(true, pid);
            this.display = display;
            this.setMirrorMessagingInterface(new SwingInProcessMessagingInterface(this, pid));
            this.initialize(false);
        }

        protected void asyncUIExec(Runnable runnable) {
            this.display.asyncExec(runnable);
        }

        public boolean isUIThread() {
            return this.display.getThread() == Thread.currentThread();
        }
    }

    static class SwingInProcessMessagingInterface
    extends InProcessMessagingInterface {
        public SwingInProcessMessagingInterface(InProcessMessagingInterface mirrorMessagingInterface, int pid) {
            super(false, pid);
            this.setMirrorMessagingInterface(mirrorMessagingInterface);
            this.initialize(false);
        }

        protected void asyncUIExec(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }

        public boolean isUIThread() {
            return SwingUtilities.isEventDispatchThread();
        }
    }
}

