/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.xml.XmlValueHandler;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlValueHandlerUtils {
    private static final Log log = LogFactory.getLog(XmlValueHandlerUtils.class);
    private static final XmlValueHandlerUtils INSTANCE = new XmlValueHandlerUtils();
    private final ReferenceMap cache = new ReferenceMap(2, 0);

    public static XmlValueHandlerUtils instance() {
        return INSTANCE;
    }

    private XmlValueHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XmlValueHandler> getHandlers() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.cache;
        synchronized (referenceMap) {
            List<XmlValueHandler> handlers = (List<XmlValueHandler>)this.cache.get(cacheKey);
            if (handlers == null) {
                ExtensionsRegistry extensionsRegistry = ExtensionsEnvironment.getExtensionsRegistry();
                handlers = extensionsRegistry.getExtensions(XmlValueHandler.class);
                this.cache.put(cacheKey, handlers);
            }
            return handlers;
        }
    }

    public boolean writeToXml(Object value, JRXmlExporter exporter) throws IOException {
        for (XmlValueHandler handler : this.getHandlers()) {
            if (!handler.writeToXml(value, exporter)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handler " + handler + " wrote value " + value));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No handler wrote value " + value));
        }
        return false;
    }
}

