/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.export.BoxStyle;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import org.apache.poi.hssf.usermodel.HSSFFont;

class StyleInfo {
    protected final short mode;
    protected final short backcolor;
    protected final short horizontalAlignment;
    protected final short verticalAlignment;
    protected final short rotation;
    protected final HSSFFont font;
    protected final BoxStyle box;
    protected final boolean wrapText;
    protected final boolean cellLocked;
    protected final boolean cellHidden;
    private short dataFormat = (short)-1;
    private int hashCode;

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), true, true, false);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked, boolean cellHidden) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), wrapText, cellLocked, cellHidden);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean cellLocked, boolean cellHidden) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), true, cellLocked, cellHidden);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), wrapText, true, false);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, true, false);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, wrapText, true, false);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean cellLocked, boolean cellHidden) {
        this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, cellLocked, cellHidden);
    }

    public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean cellHidden) {
        this.mode = mode;
        this.backcolor = backcolor;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.rotation = rotation;
        this.font = font;
        this.box = box;
        this.wrapText = wrapText;
        this.cellLocked = cellLocked;
        this.cellHidden = cellHidden;
        this.hashCode = this.computeHash();
    }

    protected int computeHash() {
        int hash = this.mode;
        hash = 31 * hash + this.backcolor;
        hash = 31 * hash + this.horizontalAlignment;
        hash = 31 * hash + this.verticalAlignment;
        hash = 31 * hash + this.rotation;
        hash = 31 * hash + (this.font == null ? 0 : (int)this.font.getIndex());
        hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
        hash = 31 * hash + this.dataFormat;
        hash = 31 * hash + (this.wrapText ? 0 : 1);
        hash = 31 * hash + (this.cellLocked ? 0 : 1);
        hash = 31 * hash + (this.cellHidden ? 0 : 1);
        return hash;
    }

    public void setDataFormat(short dataFormat) {
        this.dataFormat = dataFormat;
        this.hashCode = this.computeHash();
    }

    public boolean hasDataFormat() {
        return this.dataFormat != -1;
    }

    public short getDataFormat() {
        return this.dataFormat;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        StyleInfo s = (StyleInfo)o;
        return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndex() == this.font.getIndex()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation && s.wrapText == this.wrapText && s.cellLocked == this.cellLocked && s.cellHidden == this.cellHidden;
    }

    public String toString() {
        return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.dataFormat + "," + this.wrapText + "," + this.cellLocked + "," + this.cellHidden + ")";
    }
}

