/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xlsx;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xlsx.XlsxDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsxDataSource;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxDataAdapterService
extends AbstractDataAdapterService {
    public XlsxDataAdapterService(JasperReportsContext jasperReportsContext, XlsxDataAdapter xlsxDataAdapter) {
        super(jasperReportsContext, xlsxDataAdapter);
    }

    public XlsxDataAdapterService(XlsxDataAdapter xlsxDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), xlsxDataAdapter);
    }

    public XlsxDataAdapter getXlsxDataAdapter() {
        return (XlsxDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsxDataAdapter xlsxDataAdapter = this.getXlsxDataAdapter();
        if (xlsxDataAdapter != null) {
            try {
                String datePattern = xlsxDataAdapter.getDatePattern();
                String numberPattern = xlsxDataAdapter.getNumberPattern();
                if (xlsxDataAdapter.isQueryExecuterMode()) {
                    parameters.put("XLSX_WORKBOOK", new XSSFWorkbook((InputStream)new FileInputStream(new File(xlsxDataAdapter.getFileName()))));
                    if (datePattern != null && datePattern.length() > 0) {
                        parameters.put("XLSX_DATE_FORMAT", new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        parameters.put("XLSX_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                    }
                    parameters.put("XLSX_USE_FIRST_ROW_AS_HEADER", new Boolean(xlsxDataAdapter.isUseFirstRowAsHeader()));
                    if (!xlsxDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsxDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsxDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsxDataAdapter, names, indexes);
                        parameters.put("XLSX_COLUMN_NAMES_ARRAY", names);
                        parameters.put("XLSX_COLUMN_INDEXES_ARRAY", indexes);
                    }
                } else {
                    JRXlsxDataSource ds = new JRXlsxDataSource(new File(xlsxDataAdapter.getFileName()));
                    if (datePattern != null && datePattern.length() > 0) {
                        ds.setDateFormat(new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        ds.setNumberFormat(new DecimalFormat(numberPattern));
                    }
                    ds.setUseFirstRowAsHeader(xlsxDataAdapter.isUseFirstRowAsHeader());
                    if (!xlsxDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsxDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsxDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsxDataAdapter, names, indexes);
                        ds.setColumnNames(names, indexes);
                    }
                    parameters.put("REPORT_DATA_SOURCE", ds);
                }
            }
            catch (Exception e) {
                throw new JRException(e);
            }
        }
    }

    private void setupColumns(XlsxDataAdapter xlsxDataAdapter, String[] names, int[] indexes) {
        for (int i = 0; i < names.length; ++i) {
            names[i] = "" + xlsxDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsxDataAdapter.getColumnIndexes().size() > i ? xlsxDataAdapter.getColumnIndexes().get(i) : i;
        }
    }
}

