/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.PropertyMaps;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapImpl
implements PropertyMap {
    private final String _mapName;
    private final short _mapType;
    private final Map<String, PropertyMap.Property> _props = new LinkedHashMap<String, PropertyMap.Property>();
    private final PropertyMaps _owner;

    public PropertyMapImpl(String name, short type, PropertyMaps owner) {
        this._mapName = name;
        this._mapType = type;
        this._owner = owner;
    }

    @Override
    public String getName() {
        return this._mapName;
    }

    public short getType() {
        return this._mapType;
    }

    public PropertyMaps getOwner() {
        return this._owner;
    }

    @Override
    public int getSize() {
        return this._props.size();
    }

    @Override
    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    @Override
    public PropertyMap.Property get(String name) {
        return this._props.get(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public Object getValue(String name, Object defaultValue) {
        PropertyMap.Property prop = this.get(name);
        Object value = defaultValue;
        if (prop != null && prop.getValue() != null) {
            value = prop.getValue();
        }
        return value;
    }

    @Override
    public PropertyImpl put(String name, DataType type, Object value) {
        return this.put(name, type, (byte)0, value);
    }

    public PropertyImpl put(String name, DataType type, byte flag, Object value) {
        PropertyImpl prop = new PropertyImpl(name, type, flag, value);
        this._props.put(DatabaseImpl.toLookupName(name), prop);
        return prop;
    }

    @Override
    public PropertyImpl remove(String name) {
        return (PropertyImpl)this._props.remove(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Iterator<PropertyMap.Property> iterator() {
        return this._props.values().iterator();
    }

    @Override
    public void save() throws IOException {
        this.getOwner().save();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("".equals(this.getName()) ? "<DEFAULT>" : this.getName()).append(" {");
        Iterator<PropertyMap.Property> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    static final class PropertyImpl
    implements PropertyMap.Property {
        private final String _name;
        private final DataType _type;
        private final byte _flag;
        private Object _value;

        private PropertyImpl(String name, DataType type, byte flag, Object value) {
            this._name = name;
            this._type = type;
            this._flag = flag;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public DataType getType() {
            return this._type;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object newValue) {
            this._value = newValue;
        }

        public byte getFlag() {
            return this._flag;
        }

        public String toString() {
            Object val = this.getValue();
            if (val instanceof byte[]) {
                val = ByteUtil.toHexString((byte[])val);
            }
            return this.getName() + "[" + (Object)((Object)this.getType()) + ":" + this._flag + "]=" + val;
        }
    }
}

