/*
 * Decompiled with CFR 0.152.
 */
package jlfSistemas;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public abstract class NumberToLetterConverter {
    private static final String[] UNIDADES = new String[]{"", "UN ", "DOS ", "TRES ", "CUATRO ", "CINCO ", "SEIS ", "SIETE ", "OCHO ", "NUEVE ", "DIEZ ", "ONCE ", "DOCE ", "TRECE ", "CATORCE ", "QUINCE ", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE", "VEINTE"};
    private static final String[] DECENAS = new String[]{"VENTI", "TREINTA ", "CUARENTA ", "CINCUENTA ", "SESENTA ", "SETENTA ", "OCHENTA ", "NOVENTA ", "CIEN "};
    private static final String[] CENTENAS = new String[]{"CIENTO ", "DOSCIENTOS ", "TRESCIENTOS ", "CUATROCIENTOS ", "QUINIENTOS ", "SEISCIENTOS ", "SETECIENTOS ", "OCHOCIENTOS ", "NOVECIENTOS "};

    public static String convertNumberToLetter(String number) throws NumberFormatException {
        return NumberToLetterConverter.convertNumberToLetter(Double.parseDouble(number));
    }

    public static String convertNumberToLetter2(String number) throws NumberFormatException {
        return NumberToLetterConverter.convertNumberToLetter2(Double.parseDouble(number));
    }

    public static String convertNumberToLetter(double doubleNumber) throws NumberFormatException {
        StringBuilder converted = new StringBuilder();
        DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
        simbolos.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("###.##", simbolos);
        format.setRoundingMode(RoundingMode.DOWN);
        String formatedDouble = format.format(doubleNumber);
        doubleNumber = Double.parseDouble(formatedDouble);
        if (doubleNumber > 9.99999999E8) {
            throw new NumberFormatException("El numero es mayor de 999'999.999, no es posible convertirlo");
        }
        if (doubleNumber < 0.0) {
            throw new NumberFormatException("El numero debe ser positivo");
        }
        String[] splitNumber = String.valueOf(doubleNumber).replace('.', '#').split("#");
        int millon = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 8)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 7)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 6)));
        if (millon == 1) {
            converted.append("UN MILLON ");
        } else if (millon > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(millon)) + "MILLONES ");
        }
        int miles = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 5)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 4)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 3)));
        if (miles == 1) {
            converted.append("UN MIL ");
        } else if (miles > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(miles)) + "MIL ");
        }
        int cientos = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 2)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 1)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 0)));
        if (cientos == 1) {
            converted.append("UN");
        }
        if (millon + miles + cientos == 0) {
            converted.append("CERO");
        }
        if (cientos > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(cientos)));
        }
        converted.append("BOLIVARES");
        int centavos = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 2)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 1)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 0)));
        if (centavos == 1) {
            converted.append(" CON UN CENTAVO");
        } else if (centavos > 1) {
            converted.append(" CON " + NumberToLetterConverter.convertNumber(String.valueOf(centavos)) + "CENTIMOS");
        }
        return converted.toString();
    }

    public static String convertNumberToLetter2(double doubleNumber) throws NumberFormatException {
        StringBuilder converted = new StringBuilder();
        DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
        simbolos.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("###.##", simbolos);
        format.setRoundingMode(RoundingMode.DOWN);
        String formatedDouble = format.format(doubleNumber);
        doubleNumber = Double.parseDouble(formatedDouble);
        if (doubleNumber > 9.99999999E8) {
            throw new NumberFormatException("El numero es mayor de 999'999.999, no es posible convertirlo");
        }
        if (doubleNumber < 0.0) {
            throw new NumberFormatException("El numero debe ser positivo");
        }
        String[] splitNumber = String.valueOf(doubleNumber).replace('.', '#').split("#");
        int millon = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 8)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 7)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 6)));
        if (millon == 1) {
            converted.append("UN MILLON ");
        } else if (millon > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(millon)) + "MILLONES ");
        }
        int miles = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 5)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 4)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 3)));
        if (miles == 1) {
            converted.append("UN MIL ");
        } else if (miles > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(miles)) + "MIL ");
        }
        int cientos = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 2)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 1)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[0], 0)));
        if (cientos == 1) {
            converted.append("UN");
        }
        if (millon + miles + cientos == 0) {
            converted.append("CERO");
        }
        if (cientos > 1) {
            converted.append(NumberToLetterConverter.convertNumber(String.valueOf(cientos)));
        }
        converted.append("");
        int centavos = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 2)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 1)) + String.valueOf(NumberToLetterConverter.getDigitAt(splitNumber[1], 0)));
        if (centavos == 1) {
            converted.append("");
        } else if (centavos > 1) {
            converted.append("" + NumberToLetterConverter.convertNumber(String.valueOf(centavos)) + "");
        }
        return converted.toString();
    }

    private static String convertNumber(String number) {
        int k;
        if (number.length() > 3) {
            throw new NumberFormatException("La longitud maxima debe ser 3 digitos");
        }
        if (number.equals("100")) {
            return "CIEN";
        }
        StringBuilder output = new StringBuilder();
        if (NumberToLetterConverter.getDigitAt(number, 2) != 0) {
            output.append(CENTENAS[NumberToLetterConverter.getDigitAt(number, 2) - 1]);
        }
        if ((k = Integer.parseInt(String.valueOf(NumberToLetterConverter.getDigitAt(number, 1)) + String.valueOf(NumberToLetterConverter.getDigitAt(number, 0)))) <= 20) {
            output.append(UNIDADES[k]);
        } else if (k > 30 && NumberToLetterConverter.getDigitAt(number, 0) != 0) {
            output.append(DECENAS[NumberToLetterConverter.getDigitAt(number, 1) - 2] + "Y " + UNIDADES[NumberToLetterConverter.getDigitAt(number, 0)]);
        } else {
            output.append(DECENAS[NumberToLetterConverter.getDigitAt(number, 1) - 2] + UNIDADES[NumberToLetterConverter.getDigitAt(number, 0)]);
        }
        return output.toString();
    }

    private static int getDigitAt(String origin, int position) {
        if (origin.length() > position && position >= 0) {
            return origin.charAt(origin.length() - position - 1) - 48;
        }
        return 0;
    }
}

